﻿namespace Code6587EN.Ch01.ChangeSiteLogo
{
    using System;
    using Microsoft.SharePoint;

    /// <summary>
    /// Console Application to set the Site Logo
    /// </summary>
    class Program
    {
        static void Main(string[] args)
        {
            // Open the SharePoint Site Collection containing the SharePoint Site in a Using statement
            using (var site = new SPSite("http://sharepoint/site"))
            {
                // Open the SharePoint Site in a Using statement
                using (var web = site.OpenWeb())
                {
                    // Set the URL to the Logo
                    web.SiteLogoUrl = "/SiteAssets/logo.png";

                    // Set a Description for the Logo
                    web.SiteLogoDescription = "My Code Site";

                    // Update the SharePoint Site
                    web.Update();
                }
            }

            // Wait for a key to be pressed before closing the application
            Console.WriteLine("Press Any Key to Continue...");
            Console.Read();
        }
    }
}
